using System;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using UnityEngine;

namespace hive {
    public class HiveUnityProjectID
    {
        // 프로젝트의 경로에 따른 프로젝트 ID를 반환함.
        public static string GetProjectID() {
            return GenerateGUIDFromString(Application.dataPath);
        }
        
        // 사용 플랫폼에 따른 프로젝트 ID를 반환함.
        public static string GetProjectIDWithPlatform()
        {
            Debug.Log(GenerateProjectPathGUID());
            return GenerateProjectPathGUID();
        }

        private static string GenerateProjectPathGUID()
        {
            string projectPathWithPlatform = Application.dataPath + Application.platform.ToString();
            return GenerateGUIDFromString(projectPathWithPlatform);
        }

        private static string GenerateGUIDFromString(string input)
        {
            try
            {
                byte[] bytes = Encoding.UTF8.GetBytes(input);
                using (SHA1 sha1 = SHA1.Create())
                {
                    byte[] hashBytes = sha1.ComputeHash(bytes);
                    Guid guid = new Guid(hashBytes.Take(16).ToArray());
                    return guid.ToString();
                }
            }
            catch (Exception ex)
            {
                UnityEngine.Debug.LogError($"Failed to generate GUID from string. Error: {ex.Message}");
                return null;
            }
        }
    }
}